package com.ejie.ab04b.dao.comun;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.JdbcTemplate;

/**
 * @author GFI
 * */
public final class UtilDAO {

	/**
	 * Constructor de UtilDAO.
	 */
	private UtilDAO() {

	}

	/**
	 * Recupera el siguiente valor de la secuencia que le pasemos por parametro
	 * 
	 *  jdbcTemplate
	 *            JdbcTemplate
	 *  secuencia
	 *            String
	 *  Long.
	 *
	 * @param jdbcTemplate the jdbc template
	 * @param secuencia the secuencia
	 * @return the next id
	 */
	public static Long getNextId(JdbcTemplate jdbcTemplate, String secuencia) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT ");
		query.append(secuencia);
		query.append(".NEXTVAL FROM DUAL ");
		List<Object> params = new ArrayList<Object>();
		return jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 *  rs
	 *            resultset
	 *  columnName
	 *            String
	 *  boolean.
	 *
	 * @param rs the rs
	 * @param columnName the column name
	 * @return true, if successful
	 * @throws SQLException             excepción
	 */
	public static boolean hasColumn(ResultSet rs, String columnName)
			throws SQLException {
		ResultSetMetaData rsmd = rs.getMetaData();
		int columns = rsmd.getColumnCount();
		for (int x = 1; x <= columns; x++) {
			if (columnName.equals(rsmd.getColumnName(x))) {
				return true;
			}
		}
		return false;
	}
}